
var flipbookController = new TKController({
    id: 'flipbook',
    actions: [
    {selector: '.left_arrow', action: 'previousPage'},
    {selector: '.right_arrow', action: 'nextPage'}
   // {selector: '.left_bar', action: 'previousPage'},
   // {selector: '.right_bar', action: 'nextPage'}
  ],
    backButton: '.home',
    navigatesTo: [
    {selector: '#flipbook > .home', controller: 'home'}
  ],
    pages: [],
    currentPage: 0,
    pageCount: 16,
    animInterval: null,
    animating: false,
    animatingSpeed: 100,
    animDuration: 1,
    animStyle: 'ease-in',
    cachedPages: 0,
    currentBG: 1
});

flipbookController.viewDidLoad = function () {
    debug("flipbookController.viewDidLoad() - Entry");
    this.toLeft = {
        duration: this.animDuration,
        timingFunction: this.animStyle,
        properties: ['-webkit-transform'],
        from: ['translateX(0px)'],
        to: ['translateX(-550px)']
    };
    this.toRight = {
        duration: this.animDuration,
        timingFunction: this.animStyle,
        properties: ['-webkit-transform'],
        from: ['translateX(0px)'],
        to: ['translateX(550px)']
    };

    this.oddTurn = {
        duration: this.animDuration,
        timingFunction: this.animStyle,
        properties: ['-webkit-transform'],
        from: ['translateX(550px)'],
        to: ['translateX(0px)']
    };
    
    this.pages = this.view.querySelector('.pages');    
    
    if(IS_APPLE_TV){
        this.view.querySelector('.right_arrow').style.display = 'none';
        this.view.querySelector('.left_arrow').style.display = 'none';
    }
    
    for (var i = 0; i < this.pageCount; i++) {
        this.pages[i] = {};
        this.pages[i].cached = false;
    }

    this.currentEvenPage = this.createPage(0, true);
    this.nextOddPage = this.createPage(1, true);
    this.nextEvenPage = this.createPage(2, true);
    this.pages.appendChild(this.currentEvenPage);
    this.pages.appendChild(this.nextOddPage);
    this.pages.appendChild(this.nextEvenPage);
};

flipbookController.createPage = function (pageIndex, forward) {
    debug("createPage - pageIndex " + pageIndex);
    var page = document.createElement('div');
    var page_content = document.createElement('div');
    var image = document.createElement('img');

    if (pageIndex % 2 == 0) {
        page.className = 'even_page';
        page.style.zIndex = this.pageCount - pageIndex;
    }
    else {
        page.className = 'odd_page';
        page.style.zIndex = (this.pageCount);
    }

    page_content.className = 'page_content';

    page.appendChild(page_content);

    if (pageIndex < 9) {
        page_content.innerHTML = "<img src='images/flipbook/page_0" + (pageIndex + 1).toString() + ".jpg'>";
        }
    else {
        page_content.innerHTML = "<img src='images/flipbook/page_" + (pageIndex + 1).toString() + ".jpg'>";
        }

    this.pages[pageIndex] = page;
    this.pages[pageIndex].pageIndex = pageIndex;
    this.pages[pageIndex].pageContent = page_content;

    if (pageIndex % 2 != 0 && forward) {
        this.pages[pageIndex].style.webkitTransform = 'translate(1200px, 0px)';
    }
    
    return page;
};

flipbookController.nextPage = function () {
    debug("Going to next page, current Page: " + this.currentPage);
    debug("This.animating = " + this.animating)
    if (this.currentPage >= this.pageCount - 1) return;
    if(this.animating) return;

    this.currentEvenPage.applyTransition(this.toLeft, false);
    this.currentEvenPage.pageContent.applyTransition(this.toRight, false);

    if ((this.currentPage % 2 == 0 && this.currentPage + 1 < this.pageCount) || this.currentPage == 0) {
        this.nextOddPage.applyTransition(this.oddTurn, false);
        this.nextOddPage.pageContent.applyTransition(this.oddTurn, false);
    }
    
    this.animating = true;
    setTimeout("flipbookController.animating = false", 1000);
   
    this.currentPage += 2;
    
    if(!IS_APPLE_TV){
        if (this.currentPage <= 0) {
            this.view.querySelector('.left_arrow').style.display = 'none';
        // this.view.querySelector('.left_bar').style.display = 'none';
        }
        else {
            this.view.querySelector('.left_arrow').style.display = 'block';
        //  this.view.querySelector('.left_bar').style.display = 'block';
        }
    }
    
    if (this.currentPage > 0 && this.currentPage < this.pageCount) {
        debug("changing to background 2 after 1 second!")
        var t = setTimeout('flipbookController.changeBackground(2)', 1000); //this._view.style.background = 'url("images/home/bg_booklet_02.jpg")';
        }
    else if (this.currentPage >= this.pageCount) {
        //debug("changing to background 3!")
        debug("changing to background 2!")
        this.view.querySelector('.right_arrow').style.display = 'none';
      //  this.view.querySelector('.right_bar').style.display = 'none';
        flipbookController.changeBackground(3); 
        // flipbookController.changeBackground(2); //only two pages
        }
    
    if(this.previousOddPage) this.pages.removeChild(this.previousOddPage);
    if(this.previousEvenPage) this.pages.removeChild(this.previousEvenPage);
    
    this.previousOddPage = this.currentOddPage;
    this.previousEvenPage = this.currentEvenPage;
    this.currentOddPage = this.nextOddPage;
    this.currentEvenPage = this.nextEvenPage;

    if(this.currentPage <= this.pageCount - 4){
        this.nextOddPage = this.createPage(this.currentPage + 1, true);
        this.nextEvenPage = this.createPage(this.currentPage + 2, true);
        this.pages.appendChild(this.nextOddPage);
        this.pages.appendChild(this.nextEvenPage);
    }
    else if(this.currentPage <= this.pageCount - 2){
        this.nextOddPage = this.createPage(this.currentPage + 1, true);
        this.nextEvenPage = undefined;
        this.pages.appendChild(this.nextOddPage);
    }
    else{
        this.nextOddPage = undefined;
        this.nextEvenPage = undefined;
    }
};

flipbookController.changeBackground = function (bg_num) {

    if (bg_num == 1 && bg_num != flipbookController.currentBG) {
        debug("Changing background to bg_flipbook_01.jpg");
        flipbookController.currentBG = 1;
        this.view.querySelector('#flipbook > .bg_1').style.opacity = 1;
        this.view.querySelector('#flipbook > .bg_2').style.opacity = 0;
        this.view.querySelector('#flipbook > .bg_3').style.opacity = 0;
    }
    else if (bg_num == 2 && bg_num != flipbookController.currentBG) {
        debug("Changing background to bg_flipbook_02.jpg");
        flipbookController.currentBG = 2;
        this.view.querySelector('#flipbook > .bg_1').style.opacity = 0;
        this.view.querySelector('#flipbook > .bg_2').style.opacity = 1;
        this.view.querySelector('#flipbook > .bg_3').style.opacity = 0;
    }
    else if (bg_num == 3 && bg_num != flipbookController.currentBG) {
        debug("Changing background to bg_flipbook_03.jpg");
        flipbookController.currentBG = 3;
        this.view.querySelector('#flipbook > .bg_1').style.opacity = 0;
        this.view.querySelector('#flipbook > .bg_2').style.opacity = 0;
        this.view.querySelector('#flipbook > .bg_3').style.opacity = 1;
    }
};


flipbookController.previousPage = function () {
    debug("Going to previous page, current Page: " + this.currentPage);
    debug("This.animating = " + this.animating);

    if (this.currentPage <= 0) return;
    if (this.animating) return;

    this.currentPage -= 2;
    
    if(!IS_APPLE_TV){
        if (this.currentPage >= this.pageCount) {
            this.view.querySelector('.right_arrow').style.display = 'none';
        //  this.view.querySelector('.right_bar').style.display = 'none';
        }
        else {
            this.view.querySelector('.right_arrow').style.display = 'block';
        //  this.view.querySelector('.right_bar').style.display = 'block';
        }
    }
    
    if(this.currentPage <= 0){
        debug("Current Page <= 0, left arrow invisible and changing background!")
        this.view.querySelector('.left_arrow').style.display = 'none';
      //  this.view.querySelector('.left_bar').style.display = 'none';
        flipbookController.changeBackground(1);
    }
    
    this.previousEvenPage.applyTransition(this.toLeft, true);
    this.previousEvenPage.pageContent.applyTransition(this.toRight, true);
    this.currentOddPage.applyTransition(this.oddTurn, true);
    this.currentOddPage.pageContent.applyTransition(this.oddTurn, true);
    
    this.animating = true;
    setTimeout("flipbookController.animating = false", 1000);

    if (this.currentPage <= 0) flipbookController.changeBackground(1);
    if (this.currentPage < this.pageCount && this.currentPage > 0) setTimeout("flipbookController.changeBackground(2)", 1000);
    
    if (this.nextOddPage) this.pages.removeChild(this.nextOddPage);
    if (this.nextEvenPage) this.pages.removeChild(this.nextEvenPage);
    
    this.nextOddPage = this.currentOddPage;
    this.nextEvenPage = this.currentEvenPage;
    this.currentOddPage = this.previousOddPage;
    this.currentEvenPage = this.previousEvenPage;
    
    if(this.currentPage > 2){
        this.previousOddPage = this.createPage(this.currentPage - 3, false)
        this.previousEvenPage = this.createPage(this.currentPage - 2, false)
       // this.previousEvenPage.style.webkitTransform = 'translateX(-1032px)';
        this.previousEvenPage.style.webkitTransform = 'translateX(-1200px)';

        this.pages.insertBefore(this.previousEvenPage, this.currentOddPage);
        this.pages.insertBefore(this.previousOddPage, this.previousEvenPage);
    }
    else if(this.currentPage == 2){
        this.previousEvenPage = this.createPage(0);
        //this.previousEvenPage.style.webkitTransform = 'translateX(-1032px)';
        this.previousEvenPage.style.webkitTransform = 'translateX(-1200px)';
        this.pages.insertBefore(this.previousEvenPage, this.currentOddPage);
        this.previousOddPage = undefined;      
    }
    else
    {
        this.previousOddPage = undefined;
        this.previousEvenPage = undefined;
    }
};

flipbookController.wantsToHandleKey = function (key) {
    return key == KEYBOARD_LEFT || key == KEYBOARD_RIGHT || key == KEYBOARD_UP || key == KEYBOARD_DOWN || key == KEYBOARD_RETURN;
}

flipbookController.keyWasPressed = function (key) {
    if (key == KEYBOARD_LEFT) {
		if (this.currentPage > 0) {
			TKUtils.playSound(SOUND_MOVED);
			this.previousPage();
		}
		else TKUtils.playSound(SOUND_LIMIT);
    }
    else if (key == KEYBOARD_RIGHT) {
		if (this.currentPage < this.pageCount - 1) {
			TKUtils.playSound(SOUND_MOVED);
			this.nextPage();
		}
		else TKUtils.playSound(SOUND_LIMIT);
    }
    else if (key == KEYBOARD_DOWN) {
		TKUtils.playSound(SOUND_LIMIT);
    }
    else if (key == KEYBOARD_UP) {
		TKUtils.playSound(SOUND_LIMIT);
    }
}